/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.BareFeatureList;
import featurefunctions.FeatureList;
import featurefunctions.Symbol;

public class QueryResult {
    FeatureList base;
    boolean[] included;
    int nIncluded;

    public QueryResult(FeatureList b) {
        this.base = b;
        this.included = new boolean[this.base.symbols.length];
        this.nIncluded = 0;
        for (int i = 0; i < this.base.symbols.length; ++i) {
            this.included[i] = false;
        }
    }

    void add(int i) {
        this.included[i] = true;
        ++this.nIncluded;
    }

    public FeatureList asFeatureList() {
        FeatureList newFeatures = new FeatureList();
        newFeatures.features = this.base.features;
        newFeatures.symbols = new Symbol[this.nIncluded];
        int index = 0;
        for (int i = 0; i < this.base.symbols.length; ++i) {
            if (!this.included[i]) continue;
            newFeatures.symbols[index] = this.base.symbols[i];
            ++index;
        }
        return newFeatures;
    }

    public BareFeatureList asBareFeatureList() {
        BareFeatureList feats = new BareFeatureList();
        feats.features = this.base.features;
        return feats;
    }

    public void fromSymbols(FeatureList from) {
        this.nIncluded = 0;
        this.included = new boolean[this.base.symbols.length];
        for (int i = 0; i < from.symbols.length; ++i) {
            for (int j = 0; j < this.base.symbols.length; ++j) {
                if (!this.base.symbols[j].matchByFeatures(from.symbols[i]).isMatch()) continue;
                this.add(j);
            }
        }
    }

    public boolean contains(QueryResult alternative) {
        for (int i = 0; i < alternative.included.length; ++i) {
            if (!alternative.included[i] || this.included[i]) continue;
            return false;
        }
        return true;
    }

    static final QueryResult fullFrom(FeatureList f) {
        QueryResult result = new QueryResult(f);
        for (int i = 0; i < f.symbols.length; ++i) {
            result.add(i);
        }
        return result;
    }
}

