/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.BareFeatureList;
import featurefunctions.BareQueryResult;
import featurefunctions.Misc;
import featurefunctions.Symbol;

public class QueryAndFeatures {
    public BareFeatureList featureList;
    public BareQueryResult queryResult;
    public boolean[] transformFeaturesUsed;

    public QueryAndFeatures(BareQueryResult q, BareFeatureList f, boolean[] featuresUsed) {
        this.featureList = f;
        this.queryResult = q;
        this.transformFeaturesUsed = featuresUsed;
    }

    public Symbol notUsedAsSymbol(Symbol transform) {
        Symbol symb = new Symbol();
        int n = Misc.countFalses(this.transformFeaturesUsed);
        symb.features = new String[n];
        symb.values = new char[n];
        int index = 0;
        for (int i = 0; i < this.transformFeaturesUsed.length; ++i) {
            if (this.transformFeaturesUsed[i]) continue;
            symb.features[index] = transform.features[i];
            symb.values[index] = transform.values[i];
            ++index;
        }
        return symb;
    }

    public static boolean[] initFeaturesUsed(int len) {
        boolean[] tfu = new boolean[len];
        for (int i = 0; i < len; ++i) {
            tfu[i] = false;
        }
        return tfu;
    }
}

