/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.Symbol;

public class MatchReport {
    char[] variableSettings = new char[Symbol.Variables.length];
    boolean misMatch;
    boolean hasAllFeatures;
    boolean[] transformFeaturesUsed;

    public MatchReport() {
        for (int i = 0; i < this.variableSettings.length; ++i) {
            this.variableSettings[i] = 48;
        }
        this.misMatch = false;
        this.hasAllFeatures = true;
    }

    public char getVariableValue(char var) {
        int j = Symbol.getVariableIndex(var);
        if (j > -1) {
            return this.variableSettings[j];
        }
        j = Symbol.getNonVariableIndex(var);
        if (j > -1) {
            return Symbol.opposite(this.variableSettings[j]);
        }
        return var;
    }

    public boolean isMatch() {
        return !this.misMatch;
    }

    public void declareMisMatch() {
        this.misMatch = true;
    }

    public void declareDoesntHaveFeature() {
        this.hasAllFeatures = false;
    }

    public boolean hasAllFeatures() {
        return this.hasAllFeatures;
    }

    public String toString() {
        StringBuffer out = new StringBuffer("MatchReport( ");
        if (this.misMatch) {
            out.append("mismatch");
        } else {
            out.append("match");
        }
        out.append(", ");
        if (this.hasAllFeatures) {
            out.append("has all features");
        } else {
            out.append("doesn't have all features");
        }
        out.append(", ");
        out.append("Variable settings: {");
        for (int i = 0; i < this.variableSettings.length; ++i) {
            out.append(" " + Symbol.Variables[i] + "=>" + this.variableSettings[i]);
        }
        out.append("}");
        out.append(")");
        return out.toString();
    }
}

