/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.BareFeatureList;
import featurefunctions.BaseSymbol;
import featurefunctions.BaseSymbolList;
import featurefunctions.ComplexSymbol;
import featurefunctions.Diacritics;
import featurefunctions.FeatureList;
import featurefunctions.Symbol;
import inputoutput.StringTable;

public class Inventory {
    ComplexSymbol[] symbols;
    Diacritics diacritics;

    public Inventory(Diacritics diacs) {
        this.symbols = new ComplexSymbol[0];
        this.diacritics = diacs;
    }

    public Inventory(BaseSymbolList bases, Diacritics diacs) {
        this.diacritics = diacs;
        this.symbols = new ComplexSymbol[bases.getLength()];
        for (int i = 0; i < bases.getLength(); ++i) {
            this.symbols[i] = new ComplexSymbol(bases.getSymbol(i), this.diacritics);
        }
    }

    public static Inventory fromTable(StringTable tab, BaseSymbolList bases, Diacritics diacritics) {
        Inventory inventory = new Inventory(diacritics);
        for (int i = 0; i < tab.rowCount(); ++i) {
            String[] row = tab.getRow(i);
            if (row.length <= 0) continue;
            ComplexSymbol symbol = ComplexSymbol.fromInventoryRow(row[0], tab.takeRowFrom(i, 1), bases, diacritics);
            inventory.add(symbol);
        }
        return inventory;
    }

    public FeatureList toFeatureList(BaseSymbolList bases, Diacritics diacritics) {
        FeatureList feats = new FeatureList();
        feats.features = bases.getFeatures();
        for (int i = 0; i < this.symbols.length; ++i) {
            Symbol s = this.symbols[i].compileDiacritics();
            feats.addSymbol(s);
        }
        return feats;
    }

    public BareFeatureList toBareFeatureList(BaseSymbolList bases, Diacritics diacritics) {
        BareFeatureList feats = new BareFeatureList();
        feats.features = bases.getFeatures();
        for (int i = 0; i < this.symbols.length; ++i) {
            BareFeatureList bareFeatureList = feats;
            bareFeatureList.getClass();
            BareFeatureList.BareSymbol symb = bareFeatureList.new BareFeatureList.BareSymbol(this.symbols[i].compileDiacritics());
            symb.origin = this.symbols[i];
            feats.addSymbol(symb);
        }
        return feats;
    }

    public int getLength() {
        return this.symbols.length;
    }

    public String getLabelAt(int i) {
        return this.symbols[i].getLabel();
    }

    public ComplexSymbol getSymbol(int i) {
        return this.symbols[i];
    }

    public void add(int index, ComplexSymbol c) {
        ComplexSymbol[] newSymbols = new ComplexSymbol[this.symbols.length + 1];
        for (int i = 0; i < this.symbols.length + 1; ++i) {
            newSymbols[i] = i < index ? this.symbols[i] : (i == index ? c : this.symbols[i - 1]);
        }
        this.symbols = newSymbols;
    }

    public void add(ComplexSymbol c) {
        this.add(this.symbols.length, c);
    }

    public ComplexSymbol[] getSymbols() {
        return this.symbols;
    }

    public void add(int index, BaseSymbol c) {
        this.add(index, new ComplexSymbol(c, this.diacritics));
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("[");
        for (int i = 0; i < this.symbols.length; ++i) {
            buff.append("\n" + this.symbols[i].toString());
        }
        buff.append("\n]");
        return buff.toString();
    }

    public String labels() {
        StringBuffer buff = new StringBuffer("{ ");
        for (int i = 0; i < this.symbols.length; ++i) {
            buff.append(this.symbols[i].getLabel() + " ");
        }
        buff.append("}");
        return buff.toString();
    }

    public String dumpForFile() {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.symbols.length; ++i) {
            if (i > 0) {
                out.append("\n");
            }
            out.append(this.symbols[i].dumpForFile());
        }
        return out.toString();
    }
}

