/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import communication.ResourceProvider;
import featurefunctions.BaseSymbolList;
import featurefunctions.Diacritics;
import featurefunctions.Misc;
import featurefunctions.SubSkeleton;

public class IPASkeleton {
    BaseSymbolList bases;
    Diacritics diacritics;
    ResourceProvider res;
    public SubSkeleton[] subSkeletons;

    public IPASkeleton(ResourceProvider r, BaseSymbolList b, Diacritics d) {
        this.res = r;
        this.bases = b;
        this.diacritics = d;
    }

    public void readFromFileUnified() {
        String[] fileNames = new String[]{"data/ipachart-consonants.txt", "data/ipachart-other.txt", "data/ipachart-vowels.txt"};
        SubSkeleton[] skeleta = new SubSkeleton[]{new SubSkeleton(fileNames, this.diacritics, this.res)};
        this.subSkeletons = skeleta;
        this.parseSubSkeletons();
    }

    public void readFromFileSeparate() {
        SubSkeleton[] skeleta = new SubSkeleton[]{new SubSkeleton("data/ipachart-consonants.txt", this.diacritics, this.res), new SubSkeleton("data/ipachart-other.txt", this.diacritics, this.res), new SubSkeleton("data/ipachart-vowels.txt", this.diacritics, this.res)};
        this.subSkeletons = skeleta;
        this.parseSubSkeletons();
    }

    public void parseSubSkeletons() {
        boolean[] baseSymbolsCovered = new boolean[this.bases.symbols.length];
        for (int i = 0; i < this.subSkeletons.length; ++i) {
            boolean[] covered = this.subSkeletons[i].readAndParse(this.bases);
            baseSymbolsCovered = Misc.orList(baseSymbolsCovered, covered);
        }
        this.checkCoverage(baseSymbolsCovered);
    }

    public void checkCoverage(boolean[] baseCoverage) {
        for (int i = 0; i < this.bases.symbols.length; ++i) {
            if (baseCoverage[i]) continue;
            System.err.println("Hm, I'm not able to map the base symbol [" + this.bases.symbols[i].toString() + "] onto the IPA Chart.");
        }
    }

    public String toString() {
        StringBuffer out = new StringBuffer("{\n");
        for (int i = 0; i < this.subSkeletons.length; ++i) {
            out.append("(" + Integer.toString(i) + ")\n" + this.subSkeletons[i].skeletonToString() + "\n");
        }
        out.append("}\n");
        return out.toString();
    }
}

