/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.BareFeatureList;
import featurefunctions.BareQueryResult;
import featurefunctions.BaseSymbol;
import featurefunctions.BaseSymbolList;
import featurefunctions.CompiledDiacritics;
import featurefunctions.ComplexSymbol;
import gui.MainScreen;

public class FindLabels
implements Runnable {
    BareFeatureList list;
    BareFeatureList originalFeatures;
    BareQueryResult queryResult;
    BaseSymbolList bases;
    CompiledDiacritics diacritics;
    MainScreen mainScreen;

    public FindLabels(MainScreen m, BareFeatureList s, BareQueryResult r, BareFeatureList orig, BaseSymbolList b, CompiledDiacritics d) {
        this.list = s;
        this.bases = b;
        this.diacritics = d;
        this.mainScreen = m;
        this.queryResult = r;
        this.originalFeatures = orig;
    }

    BaseSymbol getAntecedentBaseSymbol(int i) {
        int symb = this.queryResult.inverseMapsTo(i);
        BareFeatureList.BareSymbol bare = this.originalFeatures.getBareSymbol(symb);
        ComplexSymbol complex = bare.origin;
        return complex.base;
    }

    private void initiate() {
        for (int i = 0; i < this.list.symbols.length; ++i) {
            BaseSymbol firstbase;
            BareFeatureList.BareSymbol symb = this.list.getBareSymbol(i);
            String spelling = this.findLabelFor(symb, firstbase = this.getAntecedentBaseSymbol(i));
            symb.label = spelling == null ? "?" : spelling;
            this.signalFound(i);
            this.waitLittle();
        }
    }

    private String findLabelFor(BareFeatureList.BareSymbol target, BaseSymbol firstBase) {
        int j;
        for (j = 0; j < this.bases.symbols.length; ++j) {
            BareFeatureList bareFeatureList = this.list;
            bareFeatureList.getClass();
            BareFeatureList.BareSymbol candidate = bareFeatureList.new BareFeatureList.BareSymbol(this.bases.symbols[j]);
            if (!target.equals(candidate)) continue;
            return this.bases.symbols[j].symbol;
        }
        for (j = -1; j < this.bases.symbols.length; ++j) {
            BaseSymbol base = j == -1 ? firstBase : this.bases.symbols[j];
            BareFeatureList bareFeatureList = this.list;
            bareFeatureList.getClass();
            boolean[] spel = this.findLabelWith(target, bareFeatureList.new BareFeatureList.BareSymbol(base), this.diacritics.allAvailable());
            if (spel == null) continue;
            return FindLabels.buildSymbolFrom(base.symbol, spel, this.diacritics);
        }
        return null;
    }

    public boolean[] findLabelWith(BareFeatureList.BareSymbol target, BareFeatureList.BareSymbol base, boolean[] usedDiacritics) {
        for (int i = 0; i < this.diacritics.from.length; ++i) {
            if (!base.matches(this.diacritics.from[i]) || !target.matches(this.diacritics.to[i]) || usedDiacritics[i]) continue;
            BareFeatureList.BareSymbol newBase = base.applyCopy(this.diacritics.to[i]);
            boolean[] newUsed = this.diacritics.markUsed(i, usedDiacritics);
            if (target.equals(newBase)) {
                return newUsed;
            }
            boolean[] spel = this.findLabelWith(target, newBase, this.diacritics.markUsed(i, usedDiacritics));
            if (spel == null) continue;
            return spel;
        }
        return null;
    }

    public static String buildSymbolFrom(String base, boolean[] hasDiacritic, CompiledDiacritics diacritics) {
        String symbol = base;
        for (int i = 0; i < diacritics.diacritics.items.length; ++i) {
            if (!hasDiacritic[i]) continue;
            symbol = symbol + diacritics.diacritics.items[i].label;
        }
        return symbol;
    }

    public void waitLittle() {
        try {
            Thread.sleep(20L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void signalFound(int i) {
        this.mainScreen.fireLabelUpdated(i);
    }

    public void run() {
        this.initiate();
    }
}

