/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import communication.ResourceProvider;
import featurefunctions.Contradictions;
import featurefunctions.Dependencies;
import featurefunctions.MatchReport;
import featurefunctions.Misc;
import featurefunctions.QueryResult;
import featurefunctions.Symbol;
import gui.JTableFeatures;
import gui.MainScreen;
import inputoutput.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class FeatureList
extends AbstractTableModel {
    public String[] features = new String[0];
    public Symbol[] symbols = new Symbol[0];
    public boolean transformed = false;

    public FeatureList() {
        this.updateTableProperties();
    }

    public void readFromCSV(InputStream is) throws IOException {
        String[] nextLine;
        InputStreamReader isr = new InputStreamReader(is, "UTF8");
        CSVReader reader = new CSVReader(isr);
        String[] firstLine = reader.readNext();
        this.featuresFromLine(firstLine);
        while ((nextLine = reader.readNext()) != null) {
            Symbol symb = new Symbol();
            symb.fromInput(nextLine, this.features);
            this.addSymbol(symb);
        }
        this.updateTableProperties();
    }

    void featuresFromLine(String[] line) {
        this.features = new String[line.length - 2];
        for (int i = 0; i < line.length - 2; ++i) {
            this.features[i] = line[i + 2].trim();
        }
    }

    void addSymbol(Symbol symbol) {
        Symbol[] newsymbols = new Symbol[this.symbols.length + 1];
        for (int i = 0; i < this.symbols.length; ++i) {
            newsymbols[i] = this.symbols[i];
        }
        newsymbols[this.symbols.length] = symbol;
        this.symbols = newsymbols;
    }

    public Symbol symbolByLabel(String label) {
        Symbol s = null;
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!this.symbols[i].getLabel().equals(label)) continue;
            s = this.symbols[i];
        }
        return s;
    }

    public Symbol getSymbol(int i) {
        return this.symbols[i];
    }

    public String[] getFeatures() {
        if (this.symbols.length == 0) {
            return new String[0];
        }
        return this.symbols[0].features;
    }

    public boolean symbolLabelExists(String label) {
        boolean exists = false;
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!this.symbols[i].getLabel().equals(label)) continue;
            exists = true;
        }
        return exists;
    }

    boolean prefixToSymbolLabel(String input) {
        boolean exists = false;
        for (int i = 0; i < this.symbols.length; ++i) {
            String lab = this.symbols[i].getLabel();
            if (lab.length() < input.length() || !lab.substring(0, input.length()).equals(input)) continue;
            exists = true;
        }
        return exists;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("=Features=\n");
        for (int i = 0; i < this.symbols.length; ++i) {
            out.append(this.symbols[i].toString() + "\n");
        }
        out.append("==========\n");
        return out.toString();
    }

    boolean isSpecification(FeatureList target, Symbol commons, StringBuffer report) {
        boolean defines = false;
        System.out.println("== Checking the following feature-values: " + commons.toString() + " ==");
        FeatureList classByCommons = this.query(commons);
        if (classByCommons.matchSymbols(target)) {
            defines = true;
            System.out.println("This featureset defines the class.");
            boolean minimal = true;
            for (int i = 0; i < commons.features.length; ++i) {
                if (!this.isSpecification(target, commons.eliminateFeature(i), report)) continue;
                minimal = false;
            }
            if (minimal) {
                System.out.println("This featureset MINIMALLY defines the class.");
                report.append("A minimal specification: " + commons.toString() + "\n");
            }
        } else {
            System.out.println("This featureset does not define the class.");
        }
        return defines;
    }

    String getNaturalClass(String ss) {
        StringBuffer report = new StringBuffer("");
        FeatureList target = this.parseSymbols(ss);
        report.append("Looking at " + target.toString() + "\n\n");
        Symbol commons = target.getCommonFeaturesAsSymbol();
        System.out.println("");
        System.out.println("");
        System.out.println("NATURAL CLASS DETECTION");
        System.out.println("=======================");
        System.out.println("OK, I got these symbols:");
        System.out.println(target.toString());
        report.append("Common features " + commons.toString() + "\n\n");
        if (!this.isSpecification(target, commons, report)) {
            report.append("Not definable in features, because the set of sounds defined by their common features is:\n\n");
            report.append(this.query(commons).toString() + "\n\n\n");
        }
        return report.toString();
    }

    boolean containsSymbols(FeatureList feats) {
        for (int i = 0; i < feats.symbols.length; ++i) {
            Symbol target = feats.getSymbol(i);
            boolean gotit = false;
            for (int j = 0; j < this.symbols.length; ++j) {
                if (!this.symbols[j].matchByFeatures(target).isMatch()) continue;
                gotit = true;
            }
            if (gotit) continue;
            return false;
        }
        return true;
    }

    boolean matchSymbols(FeatureList feats) {
        return this.containsSymbols(feats) && feats.containsSymbols(this);
    }

    public FeatureList diff(Symbol[] symbols) {
        FeatureList fl = new FeatureList();
        fl.features = this.features;
        fl.symbols = symbols;
        fl.restrictFeatures(fl.getDiffFeatures());
        return fl;
    }

    public FeatureList common(Symbol[] symbols) {
        FeatureList fl = new FeatureList();
        fl.features = this.features;
        fl.symbols = symbols;
        fl.restrictFeatures(fl.getCommonFeatures());
        return fl;
    }

    public QueryResult executeQuery(Symbol querySymbol) {
        QueryResult results = new QueryResult(this);
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!this.symbols[i].matchByFeatures(querySymbol).isMatch()) continue;
            results.add(i);
        }
        return results;
    }

    FeatureList query(Symbol querySymbol) {
        return this.executeQuery(querySymbol).asFeatureList();
    }

    public FeatureList searchAndTransform(Symbol querySymbol, Symbol transformSymbol, Dependencies dependencies) {
        FeatureList newFeatures = new FeatureList();
        newFeatures.features = this.features;
        for (int i = 0; i < this.symbols.length; ++i) {
            MatchReport m = this.symbols[i].matchByFeatures(querySymbol);
            if (!m.isMatch()) continue;
            Symbol symb = this.symbols[i].applyTransformation(transformSymbol, m);
            symb = dependencies.applyTo(symb, this.symbols[i]);
            symb.setAntecedent(this.symbols[i].getLabel());
            symb.setLabel(this.findLabel(symb));
            newFeatures.addSymbol(symb);
        }
        newFeatures.setTransformed(true);
        return newFeatures;
    }

    public boolean isMinimal(QueryResult result, Symbol symbol) {
        for (int i = 0; i < symbol.values.length; ++i) {
            Symbol restricted;
            QueryResult restrictResult;
            if (Symbol.isVariable(symbol.values[i]) || !result.contains(restrictResult = this.executeQuery(restricted = symbol.eliminateFeature(i)))) continue;
            return false;
        }
        return true;
    }

    FeatureList featuresFrom(String query) {
        FeatureList newFeatures = new FeatureList();
        newFeatures.features = this.features;
        if (query.trim().length() > 0) {
            Symbol querySymbol = Symbol.parseFrom(query);
            newFeatures = this.query(querySymbol);
        }
        return newFeatures;
    }

    public FeatureList parseSymbols(String input) {
        boolean i = false;
        boolean lastcut = false;
        FeatureList filtered = new FeatureList();
        String buff = "";
        String newBuff = "";
        while (input.length() > 0) {
            newBuff = buff + input.substring(0, 1);
            if (this.prefixToSymbolLabel(newBuff)) {
                buff = newBuff;
                input = input.substring(1, input.length());
                continue;
            }
            if (this.symbolLabelExists(buff)) {
                filtered.addSymbol(this.symbolByLabel(buff));
                buff = "";
                continue;
            }
            input = input.substring(1, input.length());
        }
        if (this.symbolLabelExists(buff)) {
            filtered.addSymbol(this.symbolByLabel(buff));
        }
        filtered.features = this.features;
        return filtered;
    }

    void restrictFeatures(int[] newFeatures) {
        int i;
        Symbol[] newSymbols = new Symbol[this.symbols.length];
        String[] newFeats = new String[newFeatures.length];
        for (i = 0; i < this.symbols.length; ++i) {
            newSymbols[i] = this.symbols[i].restrictFeatures(newFeatures);
        }
        for (i = 0; i < newFeatures.length; ++i) {
            newFeats[i] = this.features[newFeatures[i]];
        }
        this.symbols = newSymbols;
        this.features = newFeats;
    }

    Symbol getCommonFeaturesAsSymbol() {
        int[] common = this.getCommonFeatures();
        Symbol symb = this.symbols[0];
        return symb.restrictFeatures(common);
    }

    int[] getCommonFeatures() {
        int[] commonFeatures = new int[]{};
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.commonFeature(i)) continue;
            commonFeatures = Misc.appendIntList(commonFeatures, i);
        }
        return commonFeatures;
    }

    int[] getDiffFeatures() {
        int[] feats = new int[]{};
        for (int i = 0; i < this.features.length; ++i) {
            if (this.commonFeature(i)) continue;
            feats = Misc.appendIntList(feats, i);
        }
        return feats;
    }

    boolean commonFeature(int f) {
        boolean common = true;
        if (this.symbols.length > 0) {
            char val = this.symbols[0].values[f];
            for (int i = 0; i < this.symbols.length; ++i) {
                if (this.symbols[i].values[f] == val) continue;
                common = false;
            }
        }
        return common;
    }

    Symbol findSymbol(Symbol feats) {
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!this.symbols[i].matchByFeatures(feats).isMatch()) continue;
            return this.symbols[i];
        }
        return null;
    }

    String findLabel(Symbol symb) {
        String label = "?";
        Symbol correspondent = this.findSymbol(symb);
        if (correspondent != null) {
            return correspondent.getLabel();
        }
        return label;
    }

    int[] computeDistances(Symbol symb) {
        int[] dists = new int[this.symbols.length];
        for (int i = 0; i < this.symbols.length; ++i) {
            dists[i] = this.symbols[i].getDistanceTo(symb);
        }
        return dists;
    }

    public boolean getTransformed() {
        return this.transformed;
    }

    public void setTransformed(boolean val) {
        this.transformed = val;
    }

    public boolean getReferential() {
        return false;
    }

    public void updateTableProperties() {
    }

    public int getColumnCount() {
        return this.features.length + 3;
    }

    public int getRowCount() {
        return this.symbols.length;
    }

    public String getColumnName(int col) {
        String name = "";
        if (col > 2) {
            name = this.features[col - 3];
        }
        return name;
    }

    public Class getColumnClass(int col) {
        if (col > 2) {
            return Character.class;
        }
        return String.class;
    }

    public Object getValueAt(int row, int col) {
        Object value;
        Symbol symb = this.symbols[row];
        switch (col) {
            case 0: {
                value = symb.getAntecedent();
                break;
            }
            case 1: {
                if (this.getTransformed()) {
                    value = "\u2192";
                    break;
                }
                value = "";
                break;
            }
            case 2: {
                value = symb.getLabel();
                break;
            }
            default: {
                value = Character.valueOf(symb.getDisplayableFeatureValue(col - 3));
            }
        }
        return value;
    }

    public void showAsFrame(MainScreen parentForm, ResourceProvider res) {
        this.showAsFrame(parentForm, res, null);
    }

    public void showAsFrame(MainScreen parentForm, ResourceProvider r, String message) {
    }

    public DefaultTableCellRenderer getRenderer(boolean centered, int size, Contradictions c, ResourceProvider r) {
        return new JTableFeatures(centered, size, this, c, r);
    }

    public Symbol getReferent() {
        return null;
    }
}

