/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import communication.ResourceProvider;
import featurefunctions.Diacritic;
import featurefunctions.Symbol;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Diacritics {
    Diacritic[] items;
    static final String filename = "data/diacritics.rules";
    ResourceProvider res;

    public Diacritics(ResourceProvider r) {
        this.res = r;
        this.items = new Diacritic[0];
        this.readFromFile();
    }

    void readFromFile() {
        try {
            String line;
            InputStream is = this.res.getResource(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF8"));
            while ((line = br.readLine()) != null) {
                this.parseFromLine(line);
            }
            is.close();
        }
        catch (Exception e) {
            System.err.println("data/diacritics.rules read Error: " + e.getMessage());
        }
    }

    void parseFromLine(String regel) {
        String[] items = regel.split(";");
        if (items.length != 3) {
            System.err.println("data/diacritics.rules readline error, line (comma-parsing): " + regel);
            for (int i = 0; i < items.length; ++i) {
                System.out.println("Item: " + items[i]);
            }
        } else {
            String[] inAndOut;
            String label = items[1].trim();
            if (label.matches("\\d+")) {
                label = String.valueOf((char)Integer.parseInt(label));
            }
            if ((inAndOut = items[2].split(">")).length != 2) {
                System.err.println("data/diacritics.rules readline error, line (arrow-parsing): " + regel);
            }
            this.add(new Diacritic(items[0], label, Symbol.parseFrom(inAndOut[0]), Symbol.parseFrom(inAndOut[1])));
        }
    }

    void add(Diacritic d) {
        Diacritic[] newItems = new Diacritic[this.items.length + 1];
        for (int i = 0; i < this.items.length; ++i) {
            newItems[i] = this.items[i];
        }
        newItems[this.items.length] = d;
        this.items = newItems;
    }

    public int getSize() {
        return this.items.length;
    }

    public Diacritic getDiacritic(int i) {
        return this.items[i];
    }

    public Diacritic getByLabel(String s) {
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.items[i].getLabel().equals(s)) continue;
            return this.items[i];
        }
        return null;
    }

    public int getIndexByName(String s) {
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.items[i].description.equals(s)) continue;
            return i;
        }
        return -1;
    }

    public Diacritic getByName(String s) {
        return this.items[this.getIndexByName(s)];
    }

    public String getLabel(int i) {
        return this.items[i].getLabel();
    }

    public String getDescription(int i) {
        return this.items[i].getDescription();
    }

    public Symbol getTo(int i) {
        return this.items[i].to;
    }

    public Symbol getFrom(int i) {
        return this.items[i].from;
    }

    public String getPrintableLabel(int i) {
        return this.items[i].getPrintableLabel();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.items.length; ++i) {
            buff.append(this.items[i].toString());
        }
        return buff.toString();
    }
}

