/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.Diacritic;
import featurefunctions.Misc;

public class DiacriticSignature {
    Diacritic[] diacritics;

    public DiacriticSignature() {
        this.diacritics = new Diacritic[0];
    }

    public DiacriticSignature(Diacritic[] diacs) {
        this.diacritics = diacs;
    }

    public boolean isSameAs(Diacritic[] alt) {
        return Misc.equalContents(DiacriticSignature.labelsOf(alt), DiacriticSignature.labelsOf(this.diacritics));
    }

    public boolean isEmpty() {
        return this.diacritics.length == 0;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("[");
        for (int i = 0; i < this.diacritics.length; ++i) {
            if (i > 0) {
                out.append(", ");
            }
            out.append(this.diacritics[i].getDescription());
        }
        out.append("]");
        return out.toString();
    }

    public static String[] labelsOf(Diacritic[] ds) {
        String[] ret = new String[ds.length];
        for (int i = 0; i < ds.length; ++i) {
            ret[i] = ds[i].getDescription();
        }
        return ret;
    }
}

