/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.Symbol;

public class Diacritic {
    String label;
    String description;
    Symbol from;
    Symbol to;

    public Diacritic() {
        this.label = "";
        this.description = "";
        this.from = new Symbol();
        this.to = new Symbol();
    }

    public Diacritic(String descr, String lb, Symbol in, Symbol out) {
        this.label = lb;
        this.description = descr;
        this.from = in;
        this.to = out;
    }

    public String getPrintableLabel() {
        return "x" + this.label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description + "\t" + this.label + "\t" + this.from.toStringBare() + "\t" + this.to.toStringBare() + "\n";
    }

    public boolean canApplyTo(Symbol symbol) {
        return symbol.agreesOn(this.from);
    }

    public String getDifferences(Symbol symbol) {
        return symbol.getDifferences(this.from).toString();
    }

    public Symbol getFrom() {
        return this.from;
    }

    public Symbol getTo() {
        return this.to;
    }

    public boolean setsFeature(String f) {
        return this.to.hasFeature(f);
    }

    public String toolTip() {
        return this.description + " :\n" + this.to.toString();
    }
}

