/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.BareFeatureList;
import featurefunctions.BareQueryResult;
import featurefunctions.FutureSearches;
import gui.ShowReport;

public class DetectNaturalClass
implements Runnable {
    public BareFeatureList base;
    BareFeatureList target;
    BareQueryResult targetQueryResult;
    int shortest = -1;
    boolean shortestOnly = false;
    public boolean stillRunning;
    ShowReport reportReceiver;
    StringBuffer report;
    int progress;

    public void setShortestOnly(boolean so) {
        this.shortestOnly = so;
        this.shortest = -1;
    }

    public boolean isNatural(BareFeatureList targetSounds) {
        this.progress = 0;
        this.report = new StringBuffer();
        this.targetQueryResult = new BareQueryResult(this.base);
        this.targetQueryResult.fromSymbols(targetSounds);
        boolean natural = false;
        BareFeatureList.PartialSymbol commons = targetSounds.commonFeaturesAsSymbol();
        if (this.isSufficientlyRestrictive(commons)) {
            this.findRestrictionsBetween(this.base.new BareFeatureList.PartialSymbol(), commons, BareQueryResult.fullFrom(this.base), 0.0, 100.0);
            natural = true;
        } else {
            BareQueryResult res = this.base.pureQuery(commons).subtract(this.targetQueryResult);
            this.sendMessage("The sounds you have selected are not definable with a feature matrix in this inventory.\nI found this out because the set of sounds defined by their common features:\n\n" + commons.toStringNamedRowed(5) + "\n\n" + "contains other sounds as well:\n\n" + res.toStringLabels() + "\n\n");
        }
        this.putProgress(100);
        this.addToReport("\n\nDone.");
        return natural;
    }

    void findRestrictionsBetween(BareFeatureList.PartialSymbol bottom, BareFeatureList.PartialSymbol candidates, BareQueryResult bottomSounds, double fromProgress, double toProgress) {
        if (!this.stillRunning) {
            return;
        }
        if (this.targetQueryResult.contains(bottomSounds)) {
            System.out.println("MINIMAL SPEC! " + bottom.toString());
            this.putProgress((int)toProgress);
            this.addSpecification(bottom);
            this.addToReport(bottom.toString());
            if (this.shortest == -1 || this.shortest > bottom.feature.length) {
                this.shortest = bottom.feature.length;
            }
            return;
        }
        if (this.shortestOnly && this.shortest > -1 && bottom.feature.length >= this.shortest) {
            this.putProgress((int)toProgress);
            return;
        }
        System.out.println("\n====Ok, doing restrictions for" + bottom.toString());
        BareFeatureList.PartialSymbol newCandidates = candidates.getCopy(this.base);
        FutureSearches future = new FutureSearches();
        for (int i = 0; i < candidates.feature.length; ++i) {
            BareFeatureList.PartialSymbol newBottom = bottom.getCopy(this.base);
            newBottom.addFeatureValue(candidates.feature[i], candidates.value[i]);
            BareQueryResult newBottomSounds = this.base.pureQuery(newBottom);
            if (!newBottomSounds.contains(bottomSounds)) {
                future.plan(newBottom, newBottomSounds, candidates.feature[i]);
                continue;
            }
            newCandidates.removeFeature(candidates.feature[i]);
        }
        int workToBeDone = 0;
        for (int i = 0; i < future.queries.length; ++i) {
            future.queries[i].setCandidates(newCandidates);
            workToBeDone += newCandidates.feature.length;
            newCandidates = newCandidates.getCopy(this.base);
            newCandidates.removeFeature(future.queries[i].feature);
        }
        int workDone = 0;
        int oldWorkDone = 0;
        double progressPerWork = (toProgress - fromProgress) / (double)workToBeDone;
        for (int i = 0; i < future.queries.length; ++i) {
            oldWorkDone = workDone;
            this.findRestrictionsBetween(future.queries[i].featureValues, future.queries[i].candidates, future.queries[i].results, fromProgress + (double)oldWorkDone * progressPerWork, fromProgress + (double)(workDone += future.queries[i].candidates.feature.length) * progressPerWork);
        }
    }

    boolean isSufficientlyRestrictive(BareFeatureList.PartialSymbol feats) {
        System.out.println("== Checking whether the following feature-values specify the target symbols: ==\n " + feats.toStringNamed() + "");
        BareQueryResult classByFeatures = this.base.pureQuery(feats);
        if (this.targetQueryResult.contains(classByFeatures)) {
            this.addSpecification(feats);
            System.out.println("==> yes they do\n");
            return true;
        }
        System.out.println("==> no they don't\n");
        return false;
    }

    public DetectNaturalClass(BareFeatureList b, BareFeatureList t) {
        this.base = b;
        this.target = t;
    }

    public void markStopped() {
        this.stillRunning = false;
    }

    public void run() {
        this.stillRunning = true;
        this.isNatural(this.target);
        if (this.stillRunning) {
            this.reportReceiver.taskIsDone();
        } else {
            this.reportReceiver.taskInterrupted();
        }
    }

    public void setReportReceiver(ShowReport r) {
        this.reportReceiver = r;
    }

    public void putProgress(int p) {
        this.progress = p;
    }

    public void addSpecification(BareFeatureList.PartialSymbol s) {
        this.reportReceiver.specs.add(s);
    }

    public void sendMessage(String s) {
        this.reportReceiver.showMessage(s);
    }

    public void addToReport(String s) {
        this.report.append("\n" + s);
        this.reportReceiver.setReport(this.report.toString(), this.progress);
    }
}

