/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import communication.ResourceProvider;
import featurefunctions.MatchReport;
import featurefunctions.Symbol;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Dependencies {
    public Symbol[] from;
    public Symbol[] to;
    static final String filename = "data/dependencies.rules";
    ResourceProvider res;

    public Dependencies(ResourceProvider r) {
        this.res = r;
        this.from = new Symbol[0];
        this.to = new Symbol[0];
        this.readFromFile();
    }

    void readFromFile() {
        try {
            String line;
            InputStream is = this.res.getResource(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                this.parseFromLine(line);
            }
            is.close();
        }
        catch (Exception e) {
            System.err.println("data/dependencies.rules read Error: " + e.getMessage());
        }
    }

    void parseFromLine(String regel) {
        String[] inAndOut = regel.split(">");
        if (inAndOut.length != 2) {
            System.err.println("dependencies.rule readline error, line " + regel);
        } else {
            this.add(Symbol.parseFrom(inAndOut[0]), Symbol.parseFrom(inAndOut[1]));
        }
    }

    void add(Symbol in, Symbol out) {
        Symbol[] newFrom = new Symbol[this.from.length + 1];
        Symbol[] newTo = new Symbol[this.to.length + 1];
        for (int i = 0; i < this.from.length; ++i) {
            newFrom[i] = this.from[i];
            newTo[i] = this.to[i];
        }
        newFrom[this.from.length] = in;
        newTo[this.from.length] = out;
        this.from = newFrom;
        this.to = newTo;
    }

    public Symbol applyTo(Symbol input, Symbol antecedent) {
        MatchReport report;
        int i;
        for (i = 0; i < this.from.length; ++i) {
            report = input.matchByFeatures(this.from[i]);
            MatchReport original = antecedent.matchByFeatures(this.from[i]);
            if (!report.hasAllFeatures() || !report.isMatch() || original.isMatch()) continue;
            input = input.applyTransformation(this.to[i], report);
        }
        for (i = 0; i < this.from.length; ++i) {
            report = input.matchByFeatures(this.from[i]);
            if (!report.hasAllFeatures() || !report.isMatch()) continue;
            input = input.applyTransformation(this.to[i], report);
        }
        return input;
    }
}

