/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import communication.ResourceProvider;
import featurefunctions.MatchReport;
import featurefunctions.Misc;
import featurefunctions.Symbol;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Contradictions {
    Symbol[] matches;
    static final String filename = "data/contradictions.rules";
    ResourceProvider res;

    public Contradictions(ResourceProvider r) {
        this.res = r;
        this.matches = new Symbol[0];
        this.readFromFile();
    }

    void readFromFile() {
        try {
            String line;
            InputStream is = this.res.getResource(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                Symbol newContradiction = Symbol.parseFrom(line);
                this.add(newContradiction);
            }
        }
        catch (Exception e) {
            System.err.println("data/contradictions.rules read Error: " + e.getMessage());
        }
    }

    void add(Symbol symb) {
        Symbol[] newmatches = new Symbol[this.matches.length + 1];
        for (int i = 0; i < this.matches.length; ++i) {
            newmatches[i] = this.matches[i];
        }
        newmatches[this.matches.length] = symb;
        this.matches = newmatches;
    }

    public int[] findContradictions(Symbol symbol) {
        return Misc.concatIntLists(Contradictions.findOvertContradictions(symbol), this.findImplicitContradictions(symbol));
    }

    public static int[] findOvertContradictions(Symbol symbol) {
        if (symbol.hasOvertContradictions()) {
            int[] n = new int[]{-1};
            return n;
        }
        int[] n = new int[]{};
        return n;
    }

    public int[] findImplicitContradictions(Symbol symbol) {
        boolean[] violations = new boolean[this.matches.length];
        int nViolations = 0;
        for (int i = 0; i < this.matches.length; ++i) {
            MatchReport test = symbol.matchByFeatures(this.matches[i]);
            if (!test.isMatch() || !test.hasAllFeatures()) continue;
            violations[i] = true;
            ++nViolations;
        }
        int j = 0;
        int[] contradictions = new int[nViolations];
        for (int i = 0; i < this.matches.length; ++i) {
            if (!violations[i]) continue;
            contradictions[j] = i;
            ++j;
        }
        return contradictions;
    }

    public String getReport(Symbol symbol) {
        return this.getOvertReport(symbol) + this.getImplicitReport(symbol);
    }

    public String getOvertReport(Symbol symbol) {
        String[] overtContr = symbol.overtContradictionReport();
        if (overtContr.length > 0) {
            StringBuffer out = new StringBuffer();
            String c = "contradiction";
            String d = "combination";
            String v = "is";
            if (overtContr.length > 1) {
                c = c + "s";
                d = d + "s";
                v = "are";
            }
            out.append("This symbol contains " + Integer.toString(overtContr.length) + " 'explicit' " + c + ".\nIt contains the following feature " + d + ", which " + v + " contradictory:\n");
            for (int i = 0; i < overtContr.length; ++i) {
                out.append(overtContr[i] + "\n");
            }
            out.append("\n\n");
            return out.toString();
        }
        return "";
    }

    public String getImplicitReport(Symbol symbol) {
        int[] violations = this.findImplicitContradictions(symbol);
        if (violations.length == 0) {
            return "";
        }
        StringBuffer toreturn = new StringBuffer();
        String c = "contradiction";
        if (violations.length > 1) {
            c = c + "s";
        }
        toreturn.append("This symbol contains " + Integer.toString(violations.length) + " 'implicit' " + c + ".\n");
        for (int i = 0; i < violations.length; ++i) {
            toreturn.append("The following features cannot occur together: " + this.matches[violations[i]].toStringBareFancy() + "\n");
        }
        return toreturn.toString();
    }
}

