/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.BaseSymbol;
import featurefunctions.BaseSymbolList;
import featurefunctions.Diacritic;
import featurefunctions.Diacritics;
import featurefunctions.MatchReport;
import featurefunctions.Misc;
import featurefunctions.Symbol;

public class ComplexSymbol {
    public BaseSymbol base;
    public Diacritic[] diacritics;
    public Symbol featureValues;
    private Diacritics allDiacritics;

    public ComplexSymbol(BaseSymbol b, Diacritics alD) {
        this.base = b;
        this.diacritics = new Diacritic[0];
        this.allDiacritics = alD;
    }

    public ComplexSymbol(BaseSymbol b, Diacritic[] ds, Diacritics alD) {
        this.base = b;
        this.diacritics = ds;
        this.allDiacritics = alD;
    }

    public Symbol compileDiacritics() {
        Symbol symb = new Symbol();
        symb.features = this.base.features;
        symb.values = this.base.values;
        symb.symbol = this.getLabel();
        MatchReport m = new MatchReport();
        for (int i = 0; i < this.diacritics.length; ++i) {
            symb = symb.applyTransformation(this.diacritics[i].getTo(), m);
        }
        return symb;
    }

    public void compile() {
        this.featureValues = this.compileDiacritics();
    }

    public void addDiacritic(Diacritic d) {
        Diacritic[] ds = new Diacritic[this.diacritics.length + 1];
        for (int i = 0; i < this.diacritics.length; ++i) {
            ds[i] = this.diacritics[i];
        }
        ds[this.diacritics.length] = d;
        this.diacritics = ds;
    }

    public ComplexSymbol copyAndDiacriticize(Diacritic d) {
        ComplexSymbol c = new ComplexSymbol(this.base, this.allDiacritics);
        Diacritic[] ds = new Diacritic[this.diacritics.length + 1];
        for (int i = 0; i < this.diacritics.length; ++i) {
            ds[i] = this.diacritics[i];
        }
        ds[this.diacritics.length] = d;
        c.diacritics = ds;
        return c;
    }

    public String getLabel() {
        StringBuffer buff = new StringBuffer(this.base.getLabel());
        for (int i = 0; i < this.allDiacritics.getSize(); ++i) {
            for (int j = 0; j < this.diacritics.length; ++j) {
                if (!this.diacritics[j].description.equals(this.allDiacritics.items[i].description)) continue;
                buff.append(this.diacritics[j].getLabel());
            }
        }
        return buff.toString();
    }

    public String[] getDiacriticLabels() {
        String[] out = new String[this.diacritics.length];
        for (int i = 0; i < this.diacritics.length; ++i) {
            out[i] = this.diacritics[i].getLabel();
        }
        return out;
    }

    public BaseSymbol getBase() {
        return this.base;
    }

    public String getBaseLabel() {
        return this.base.getLabel();
    }

    public boolean isBare() {
        return this.diacritics.length == 0;
    }

    public int diacriticsLength() {
        return this.diacritics.length;
    }

    public Diacritic getDiacritic(int i) {
        return this.diacritics[i];
    }

    public boolean equals(ComplexSymbol alt) {
        return this.getBaseLabel() == alt.getBaseLabel() && Misc.equalContents(this.getDiacriticLabels(), alt.getDiacriticLabels());
    }

    public static ComplexSymbol fromInventoryRow(String label, String[] diacs, BaseSymbolList bases, Diacritics diacritics) {
        int index = bases.symbolByLabel(label);
        if (index == -1) {
            System.err.println("Error: Cannot find base symbol with label '" + label + "'. That's bad! Inserting empty symbol instead.");
            return new ComplexSymbol(new BaseSymbol(), diacritics);
        }
        BaseSymbol b = bases.symbols[index];
        ComplexSymbol symb = new ComplexSymbol(b, diacritics);
        for (int i = 0; i < diacs.length; ++i) {
            Diacritic d = diacritics.getByLabel(diacs[i]);
            symb.addDiacritic(d);
        }
        return symb;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(this.base.toString());
        for (int i = 0; i < this.diacritics.length; ++i) {
            buff.append("\nDiacritic " + Integer.toString(i) + ": " + this.diacritics[i].toString());
        }
        return buff.toString();
    }

    public String dumpForFile() {
        StringBuffer ds = new StringBuffer(this.base.getLabel());
        for (int i = 0; i < this.diacritics.length; ++i) {
            ds.append("\t");
            ds.append(this.diacritics[i].getLabel());
        }
        return ds.toString();
    }
}

