/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.BareFeatureList;
import featurefunctions.BareQueryResult;
import featurefunctions.FutureSearches;
import gui.ShowClassList;

public class CalculateClassList
implements Runnable {
    public BareFeatureList base;
    History history;
    boolean stillRunning;
    ShowClassList reportReceiver;
    StringBuffer report;
    int progress;

    public CalculateClassList(BareFeatureList b) {
        this.base = b;
    }

    public void initiate() {
        this.history = new History();
        this.findClassesBetween(this.base.new BareFeatureList.PartialSymbol(), this.base.getMaximalSymbol(), BareQueryResult.fullFrom(this.base), 0.0, 100.0);
    }

    public void findClassesBetween(BareFeatureList.PartialSymbol bottom, BareFeatureList.PartialSymbol top, BareQueryResult bottomSelections, double minProgress, double maxProgress) {
        if (!this.stillRunning) {
            return;
        }
        this.addSpecification(bottom, bottomSelections);
        FutureSearches future = new FutureSearches();
        BareFeatureList.PartialSymbol newTop = top.getCopy(this.base);
        for (int i = 0; i < top.feature.length; ++i) {
            BareFeatureList.PartialSymbol newBottom = bottom.getCopy(this.base);
            newBottom.addFeatureValue(top.feature[i], top.value[i]);
            BareQueryResult newBottomSounds = this.base.pureQuery(newBottom);
            if (!newBottomSounds.contains(bottomSelections) && newBottomSounds.isNotEmpty() && this.history.haventGotItYet(newBottomSounds)) {
                future.plan(newBottom, newBottomSounds, top.feature[i]);
                this.history.add(newBottomSounds);
                continue;
            }
            newTop.removeFeatureValue(top.feature[i], top.value[i]);
        }
        int workToBeDone = 0;
        for (int i = 0; i < future.queries.length; ++i) {
            newTop.removeFeature(future.queries[i].feature);
            future.queries[i].setCandidates(newTop);
            workToBeDone += newTop.feature.length;
            newTop = newTop.getCopy(this.base);
        }
        int workDone = 0;
        int oldWorkDone = 0;
        double progressPerWork = 0.0;
        if (workToBeDone > 0) {
            progressPerWork = (maxProgress - minProgress) / (double)workToBeDone;
        }
        for (int i = 0; i < future.queries.length; ++i) {
            oldWorkDone = workDone;
            this.findClassesBetween(future.queries[i].featureValues, future.queries[i].candidates, future.queries[i].results, minProgress + (double)oldWorkDone * progressPerWork, minProgress + (double)(workDone += future.queries[i].candidates.feature.length) * progressPerWork);
        }
        this.putProgress((int)maxProgress);
    }

    public void markStopped() {
        this.stillRunning = false;
    }

    public void run() {
        this.stillRunning = true;
        this.initiate();
        if (this.stillRunning) {
            this.reportReceiver.taskIsDone();
        } else {
            this.reportReceiver.taskInterrupted();
        }
    }

    public void setReportReceiver(ShowClassList r) {
        this.reportReceiver = r;
    }

    public void putProgress(int p) {
        this.progress = p;
        this.reportReceiver.putProgress(p);
    }

    public void addSpecification(BareFeatureList.PartialSymbol s, BareQueryResult res) {
        this.reportReceiver.specs.add(s, res.toStringLabels());
    }

    public void sendMessage(String s) {
        this.reportReceiver.showMessage(s);
    }

    public void addToReport(String s) {
        this.report.append("\n" + s);
        this.reportReceiver.setReport(this.report.toString(), this.progress);
    }

    class History {
        BareQueryResult[] classes = new BareQueryResult[0];

        History() {
        }

        void add(BareQueryResult res) {
            BareQueryResult[] update = new BareQueryResult[this.classes.length + 1];
            for (int i = 0; i < this.classes.length; ++i) {
                update[i] = this.classes[i];
            }
            update[this.classes.length] = res;
            this.classes = update;
        }

        boolean haventGotItYet(BareQueryResult res) {
            for (int i = 0; i < this.classes.length; ++i) {
                if (!this.classes[i].isEqualTo(res)) continue;
                return false;
            }
            return true;
        }
    }
}

