/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import communication.ResourceProvider;
import featurefunctions.BaseSymbol;
import inputoutput.StringTable;
import java.io.InputStream;

public class BaseSymbolList {
    public String[] features;
    public BaseSymbol[] symbols = new BaseSymbol[0];
    ResourceProvider res;
    String filename = "data/basefeatures.txt";

    public BaseSymbolList(ResourceProvider r) {
        this.res = r;
        this.readFromFile();
    }

    public void readFromFile() {
        StringTable buff = new StringTable();
        try {
            InputStream is = this.res.getResource(this.filename);
            buff.fromFile(is, "\t");
        }
        catch (Exception e) {
            System.err.println(this.filename + " read Error: " + e.getMessage());
        }
        this.features = buff.takeRowFrom(0, 2);
        for (int i = 0; i < buff.rowCount() - 1; ++i) {
            String[] line = buff.getRow(i + 1);
            BaseSymbol symb = new BaseSymbol(line, this.features);
            this.addSymbol(symb);
        }
    }

    void featuresFromLine(String[] line) {
        this.features = new String[line.length - 2];
        for (int i = 0; i < line.length - 2; ++i) {
            this.features[i] = line[i + 2].trim();
        }
    }

    void addSymbol(BaseSymbol symbol) {
        BaseSymbol[] newsymbols = new BaseSymbol[this.symbols.length + 1];
        for (int i = 0; i < this.symbols.length; ++i) {
            newsymbols[i] = this.symbols[i];
        }
        newsymbols[this.symbols.length] = symbol;
        this.symbols = newsymbols;
    }

    public int symbolByLabel(String label) {
        Object s = null;
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!this.symbols[i].getLabel().equals(label)) continue;
            return i;
        }
        return -1;
    }

    public BaseSymbol getSymbol(int i) {
        return this.symbols[i];
    }

    public boolean symbolLabelExists(String label) {
        boolean exists = false;
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!this.symbols[i].getLabel().equals(label)) continue;
            exists = true;
        }
        return exists;
    }

    boolean prefixToSymbolLabel(String input) {
        boolean exists = false;
        for (int i = 0; i < this.symbols.length; ++i) {
            String lab = this.symbols[i].getLabel();
            if (lab.length() < input.length() || !lab.substring(0, input.length()).equals(input)) continue;
            exists = true;
        }
        return exists;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("=Features=\n");
        for (int i = 0; i < this.symbols.length; ++i) {
            out.append(this.symbols[i].toString() + "\n");
        }
        out.append("==========\n");
        return out.toString();
    }

    public String[] getFeatures() {
        return this.features;
    }

    public int getLength() {
        return this.symbols.length;
    }

    public String getLabelAt(int i) {
        return this.symbols[i].getLabel();
    }
}

