/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.MatchReport;

public class BaseSymbol {
    public String[] features;
    public char[] values;
    public String symbol;
    public String soundFile;
    public String antecedent;
    public static final String unknown = "?";
    public static final char plus = '+';
    public static final char min = '-';
    public static final char nul = '0';
    public static final char alpha = 'a';
    public static final char nonalpha = 'A';
    public static final char beta = 'b';
    public static final char nonbeta = 'B';
    public static final char[] Variables = new char[]{'a', 'b'};
    public static final char[] nonVariables = new char[]{'A', 'B'};
    public static final char[] displayVariables = new char[]{'\u03b1', '\u03b2'};
    public static final char displayMin = '\u2212';
    public static final char displayNon = '-';
    public static final char displayNul = ' ';

    BaseSymbol(String[] rawdata, String[] fs) {
        this.features = fs;
        this.symbol = rawdata[0];
        this.soundFile = rawdata[1];
        this.values = new char[this.features.length];
        for (int i = 0; i < this.features.length; ++i) {
            this.values[i] = rawdata[i + 2].charAt(0);
        }
    }

    public BaseSymbol() {
        this.symbol = "";
        this.soundFile = "";
        this.features = new String[0];
        this.values = new char[0];
    }

    public boolean isUnknown() {
        return this.symbol.equals(unknown);
    }

    public boolean featureMatchValue(String feat, char val) {
        boolean mismatch = false;
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.features[i].equals(feat) || this.values[i] == val) continue;
            mismatch = true;
        }
        return !mismatch;
    }

    public int getDistanceTo(BaseSymbol referent) {
        int distance = 0;
        for (int i = 0; i < referent.features.length; ++i) {
            if (referent.values[i] == this.values[i]) continue;
            ++distance;
        }
        return distance;
    }

    public BaseSymbol getCopy() {
        BaseSymbol symb = this.headerCopy();
        symb.copyFeatureValuesFrom(this);
        return symb;
    }

    public BaseSymbol headerCopy() {
        BaseSymbol symb = new BaseSymbol();
        symb.symbol = this.symbol;
        symb.soundFile = this.soundFile;
        symb.antecedent = this.antecedent;
        return symb;
    }

    public void copyFeatureValuesFrom(BaseSymbol symb) {
        int len = symb.features.length;
        this.features = new String[len];
        this.values = new char[len];
        for (int i = 0; i < len; ++i) {
            this.features[i] = new String(symb.features[i]);
            this.values[i] = symb.values[i];
        }
    }

    public String getLabel() {
        return this.symbol;
    }

    public void setLabel(String l) {
        this.symbol = l;
    }

    public String getAntecedent() {
        return this.antecedent;
    }

    public void setAntecedent(String antec) {
        this.antecedent = antec;
    }

    public String getSoundFile() {
        return this.soundFile;
    }

    public char getFeatureValue(int f) {
        return this.values[f];
    }

    public char getDisplayableFeatureValue(int f) {
        char val = this.getFeatureValue(f);
        if (val == '0') {
            return ' ';
        }
        if (val == '-') {
            return '\u2212';
        }
        return val;
    }

    public char getDisplayableFeatureValueWithNull(int f) {
        char val = this.getFeatureValue(f);
        if (val == '-') {
            return '\u2212';
        }
        return val;
    }

    int getFeatureIndex(String featureName) {
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.features[i].equals(featureName)) continue;
            return i;
        }
        return -1;
    }

    boolean hasFeature(String featureName) {
        return this.getFeatureIndex(featureName) > -1;
    }

    char getValueForFeature(String featureName) {
        char val = ' ';
        int i = this.getFeatureIndex(featureName);
        if (i > -1) {
            return this.values[i];
        }
        return val;
    }

    public String toString() {
        return this.symbol + "=" + this.toStringBare();
    }

    public String toStringBare() {
        StringBuffer out = new StringBuffer();
        out.append("[");
        for (int i = 0; i < this.features.length; ++i) {
            if (i > 0) {
                out.append(", ");
            }
            out.append(this.values[i] + this.features[i]);
        }
        out.append("]");
        return out.toString();
    }

    void addFeatureValue(String feature, char value) {
        int index = this.getFeatureIndex(feature);
        if (index > -1) {
            this.values[index] = value;
        } else {
            String[] newFeatures = new String[this.features.length + 1];
            char[] newValues = new char[this.features.length + 1];
            for (int i = 0; i < this.features.length; ++i) {
                newFeatures[i] = this.features[i];
                newValues[i] = this.values[i];
            }
            newFeatures[this.features.length] = feature;
            newValues[this.features.length] = value;
            this.features = newFeatures;
            this.values = newValues;
        }
    }

    BaseSymbol restrictFeatures(int[] newFeatures) {
        BaseSymbol symb = this.headerCopy();
        symb.features = new String[newFeatures.length];
        symb.values = new char[newFeatures.length];
        for (int i = 0; i < newFeatures.length; ++i) {
            symb.features[i] = this.features[newFeatures[i]];
            symb.values[i] = this.values[newFeatures[i]];
        }
        return symb;
    }

    public BaseSymbol eliminateFeature(int index) {
        BaseSymbol symb = this.getCopy();
        symb.removeFeature(index);
        return symb;
    }

    public void removeFeature(int index) {
        String[] newFeatures = new String[this.features.length - 1];
        char[] newValues = new char[this.features.length - 1];
        int t = 0;
        for (int i = 0; i < this.features.length - 1; ++i) {
            t = i < index ? i : i + 1;
            newFeatures[i] = this.features[t];
            newValues[i] = this.values[t];
        }
        this.features = newFeatures;
        this.values = newValues;
    }

    public BaseSymbol applyTransformation(BaseSymbol transfSymbol, MatchReport match) {
        BaseSymbol symb = new BaseSymbol();
        symb.symbol = unknown;
        symb.features = new String[this.features.length];
        symb.values = new char[this.values.length];
        for (int i = 0; i < this.features.length; ++i) {
            symb.features[i] = this.features[i];
            int value = this.values[i];
            if (transfSymbol.hasFeature(this.features[i])) {
                int target = transfSymbol.getValueForFeature(this.features[i]);
                if (BaseSymbol.isVariable((char)target)) {
                    int toset = 48;
                    int varval = BaseSymbol.getVariableIndex((char)target);
                    if (varval > -1) {
                        toset = match.variableSettings[varval];
                    }
                    if ((varval = BaseSymbol.getNonVariableIndex((char)target)) > -1) {
                        toset = BaseSymbol.opposite(match.variableSettings[varval]);
                    }
                    value = toset;
                } else {
                    value = target;
                }
            }
            symb.values[i] = value;
        }
        return symb;
    }

    public BaseSymbol whatDoINotHave(BaseSymbol other) {
        BaseSymbol symb = this.headerCopy();
        for (int i = 0; i < other.features.length; ++i) {
            String feat = other.features[i];
            char val = other.values[i];
            if (this.getValueForFeature(feat) == val) continue;
            symb.addFeatureValue(feat, val);
        }
        return symb;
    }

    static final int getIndexIn(char[] arr, char value) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != value) continue;
            return i;
        }
        return -1;
    }

    static final int getVariableIndex(char value) {
        return BaseSymbol.getIndexIn(Variables, value);
    }

    static final int getNonVariableIndex(char value) {
        return BaseSymbol.getIndexIn(nonVariables, value);
    }

    public static final boolean isVariable(char value) {
        return BaseSymbol.getVariableIndex(value) > -1 || BaseSymbol.getNonVariableIndex(value) > -1;
    }

    public static final String getDisplayVariable(char value) {
        int var = BaseSymbol.getVariableIndex(value);
        if (var > -1) {
            return Character.toString(displayVariables[var]);
        }
        var = BaseSymbol.getNonVariableIndex(value);
        if (var > -1) {
            return Character.toString('-') + Character.toString(displayVariables[var]);
        }
        return "";
    }

    public static final boolean isDisplayVariable(String val) {
        return val.length() > 0 && BaseSymbol.getDisplayVariableIndex(val.charAt(0)) > -1 || val.length() > 1 && val.charAt(0) == '-' && BaseSymbol.getDisplayVariableIndex(val.charAt(1)) > -1;
    }

    public static final int getDisplayVariableIndex(char val) {
        return BaseSymbol.getIndexIn(displayVariables, val);
    }

    public static final char getVariableFromDisplay(String value) {
        int var = BaseSymbol.getDisplayVariableIndex(value.charAt(0));
        if (var > -1) {
            return Variables[var];
        }
        var = BaseSymbol.getDisplayVariableIndex(value.charAt(1));
        if (value.charAt(0) == '-' && var > -1) {
            return nonVariables[var];
        }
        return '0';
    }

    static final char opposite(char value) {
        if (value == '+') {
            return '-';
        }
        if (value == '-') {
            return '+';
        }
        return value;
    }
}

