/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import featurefunctions.BareFeatureList;

public class BareQueryResult {
    public BareFeatureList base;
    public boolean[] included;
    public int nIncluded;
    public int[] mapsTo;

    public BareQueryResult(BareFeatureList b) {
        this.base = b;
        this.included = new boolean[this.base.symbols.length];
        this.nIncluded = 0;
        for (int i = 0; i < this.base.symbols.length; ++i) {
            this.included[i] = false;
        }
    }

    void add(int i) {
        this.included[i] = true;
        ++this.nIncluded;
    }

    public void emptyMapsTo() {
        this.mapsTo = new int[this.base.symbols.length];
        for (int i = 0; i < this.base.symbols.length; ++i) {
            this.mapsTo[i] = -1;
        }
    }

    public void setMapsTo(int from, int to) {
        this.mapsTo[from] = to;
    }

    public int inverseMapsTo(int to) {
        for (int from = 0; from < this.mapsTo.length; ++from) {
            if (this.mapsTo[from] != to) continue;
            return from;
        }
        return -1;
    }

    public BareFeatureList asBareFeatureList() {
        BareFeatureList feats = new BareFeatureList();
        feats.features = this.base.features;
        for (int i = 0; i < this.base.symbols.length; ++i) {
            if (!this.included[i]) continue;
            feats.addSymbol(this.base.getBareSymbol(i));
        }
        return feats;
    }

    public void fromSymbols(BareFeatureList from) {
        this.nIncluded = 0;
        this.included = new boolean[this.base.symbols.length];
        for (int i = 0; i < from.symbols.length; ++i) {
            for (int j = 0; j < this.base.symbols.length; ++j) {
                if (!this.base.symbols[j].equals(from.symbols[i])) continue;
                this.add(j);
            }
        }
    }

    public BareQueryResult subtract(BareQueryResult alternative) {
        BareQueryResult res = new BareQueryResult(this.base);
        for (int i = 0; i < this.included.length; ++i) {
            boolean bl = res.included[i] = this.included[i] && !alternative.included[i];
            if (!res.included[i]) continue;
            ++res.nIncluded;
        }
        return res;
    }

    public boolean contains(BareQueryResult alternative) {
        for (int i = 0; i < alternative.included.length; ++i) {
            if (!alternative.included[i] || this.included[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualTo(BareQueryResult alternative) {
        for (int i = 0; i < this.included.length; ++i) {
            if (this.included[i] == alternative.included[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isNotEmpty() {
        return this.nIncluded > 0;
    }

    public static final BareQueryResult fullFrom(BareFeatureList f) {
        BareQueryResult result = new BareQueryResult(f);
        for (int i = 0; i < f.symbols.length; ++i) {
            result.add(i);
        }
        result.emptyMapsTo();
        return result;
    }

    public String toStringLabels() {
        StringBuffer out = new StringBuffer("{");
        boolean first = true;
        for (int i = 0; i < this.included.length; ++i) {
            if (!this.included[i]) continue;
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            out.append(this.base.getBareSymbol(i).getLabel());
        }
        out.append("}");
        return out.toString();
    }

    public String mapsToString() {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.mapsTo.length; ++i) {
            out.append(Integer.toString(i) + "=>" + Integer.toString(this.mapsTo[i]) + ",");
        }
        return out.toString();
    }
}

