/*
 * Decompiled with CFR 0.152.
 */
package featurefunctions;

import communication.ResourceProvider;
import featurefunctions.BareQueryResult;
import featurefunctions.BaseSymbol;
import featurefunctions.ComplexSymbol;
import featurefunctions.Contradictions;
import featurefunctions.Dependencies;
import featurefunctions.Diacritics;
import featurefunctions.MatchReport;
import featurefunctions.Misc;
import featurefunctions.QueryAndFeatures;
import featurefunctions.Symbol;
import gui.FeatureTableRenderer;
import gui.FrameFeatureList;
import gui.MainScreen;
import inputoutput.StringTable;
import java.awt.Color;
import java.io.InputStream;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class BareFeatureList
extends AbstractTableModel {
    public String[] features = new String[0];
    public BareSymbol[] symbols = new BareSymbol[0];
    public boolean restricted = false;

    public void readBaseFromTXT(InputStream is) {
        StringTable buff = new StringTable();
        buff.fromFile(is, "\t");
        System.out.println(buff.toString());
        this.features = buff.takeRowFrom(0, 2);
        for (int i = 0; i < buff.rowCount() - 1; ++i) {
            System.out.println("Taking");
            String[] line = buff.getRow(i + 1);
            BareSymbol symb = new BareSymbol(line);
            System.out.println(symb.toString());
            this.addSymbol(symb);
        }
    }

    public BareQueryResult pureQuery(PartialSymbol query) {
        BareQueryResult results = new BareQueryResult(this);
        for (int i = 0; i < this.symbols.length; ++i) {
            MatchReport m = this.symbols[i].matchByFeatures(query);
            if (!m.isMatch()) continue;
            results.add(i);
        }
        return results;
    }

    public QueryAndFeatures searchAndTransform(Symbol querySymbol, Symbol transformSymbol, Symbol dependencySymbol) {
        BareFeatureList feats = new BareFeatureList();
        feats.features = this.features;
        BareQueryResult results = new BareQueryResult(this);
        results.emptyMapsTo();
        if (this.isVoid()) {
            return new QueryAndFeatures(results, feats, new boolean[0]);
        }
        PartialSymbol query = new PartialSymbol(querySymbol);
        PartialSymbol transform = new PartialSymbol(transformSymbol);
        PartialSymbol dependencies = new PartialSymbol(dependencySymbol);
        boolean doTransform = transformSymbol.nonVoid();
        boolean[] featuresUsed = QueryAndFeatures.initFeaturesUsed(transform.feature.length);
        System.out.println("Executing query " + query.toString());
        if (doTransform) {
            System.out.println("and transform ==> " + transform.toString());
        }
        for (int i = 0; i < this.symbols.length; ++i) {
            MatchReport m = this.symbols[i].matchByFeatures(query);
            if (!m.isMatch()) continue;
            results.add(i);
            BareSymbol b = this.symbols[i];
            if (doTransform) {
                b = this.symbols[i].apply(this, transform, m);
                featuresUsed = Misc.orList(featuresUsed, m.transformFeaturesUsed);
                b = b.apply(this, dependencies, m);
                b.antecedent = this.symbols[i].getLabel();
                b.label = "";
            }
            int newindex = feats.addSymbol(b);
            results.setMapsTo(i, newindex);
        }
        return new QueryAndFeatures(results, feats, featuresUsed);
    }

    public String findLabel(BareSymbol symb) {
        BareSymbol correspondent = this.findSymbol(symb);
        if (correspondent == null) {
            return "?";
        }
        return correspondent.getLabel();
    }

    BareSymbol findSymbol(BareSymbol feats) {
        for (int i = 0; i < this.symbols.length; ++i) {
            if (!this.symbols[i].equals(feats)) continue;
            return this.symbols[i];
        }
        return null;
    }

    public MinimalityReport isMinimal(BareQueryResult result, Symbol query, Symbol transform) {
        PartialSymbol symbol = new PartialSymbol(query);
        PartialSymbol transf = new PartialSymbol(transform);
        boolean doTransform = transform.nonVoid();
        BareQueryResult transfIdentityOn = this.pureQuery(transf);
        MinimalityReport minim = new MinimalityReport();
        for (int i = 0; i < symbol.value.length; ++i) {
            BareQueryResult subtr;
            if (Symbol.isVariable(symbol.value[i])) continue;
            PartialSymbol restricted = symbol.eliminateFeature(i);
            BareQueryResult restrictResult = this.pureQuery(restricted);
            if (result.contains(restrictResult)) {
                minim.featureSelectionsMinimal = false;
                continue;
            }
            if (!doTransform || !transfIdentityOn.contains(subtr = restrictResult.subtract(result))) continue;
            minim.featureLeavingIdentity = true;
        }
        return minim;
    }

    public BareFeatureList common(BareSymbol[] symbols) {
        BareFeatureList fl = new BareFeatureList();
        fl.features = this.features;
        fl.symbols = symbols;
        fl.restrictFeatures(fl.getCommonFeatures());
        return fl;
    }

    public BareFeatureList diff(BareSymbol[] symbols) {
        BareFeatureList fl = new BareFeatureList();
        fl.features = this.features;
        fl.symbols = symbols;
        fl.restrictFeatures(fl.getDiffFeatures());
        return fl;
    }

    int[] getDiffFeatures() {
        int[] feats = new int[]{};
        for (int i = 0; i < this.features.length; ++i) {
            if (this.commonFeature(i)) continue;
            feats = Misc.appendIntList(feats, i);
        }
        return feats;
    }

    int[] getCommonFeatures() {
        int[] commonFeatures = new int[]{};
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.commonFeature(i)) continue;
            commonFeatures = Misc.appendIntList(commonFeatures, i);
        }
        return commonFeatures;
    }

    public PartialSymbol commonFeaturesAsSymbol() {
        int[] common = this.getCommonFeatures();
        BareSymbol symb = this.symbols[0];
        return symb.restrictToPartial(common);
    }

    void restrictFeatures(int[] newFeatures) {
        int i;
        BareSymbol[] newSymbols = new BareSymbol[this.symbols.length];
        String[] newFeats = new String[newFeatures.length];
        for (i = 0; i < this.symbols.length; ++i) {
            newSymbols[i] = this.symbols[i].restrictFeatures(newFeatures);
        }
        for (i = 0; i < newFeatures.length; ++i) {
            newFeats[i] = this.features[newFeatures[i]];
        }
        this.symbols = newSymbols;
        this.features = newFeats;
        this.restricted = true;
    }

    boolean commonFeature(int f) {
        if (this.symbols.length > 0) {
            char val = this.symbols[0].values[f];
            for (int i = 0; i < this.symbols.length; ++i) {
                if (this.symbols[i].values[f] == val) continue;
                return false;
            }
        }
        return true;
    }

    public void closeUnderDiacritics(Diacritics dia) {
        for (int i = 0; i < dia.getSize(); ++i) {
            System.out.println("Applying diacritic: " + dia.getLabel(i));
            PartialSymbol conditions = new PartialSymbol(dia.getFrom(i));
            PartialSymbol changes = new PartialSymbol(dia.getTo(i));
            System.out.println("\t(Conditions: " + conditions.toString());
            System.out.println("\t Changes:    " + changes.toString() + ")");
            int len = this.symbols.length;
            for (int j = 0; j < len; ++j) {
                if (this.symbols[j].matches(conditions) && !this.symbols[j].matches(changes)) {
                    System.out.print("M");
                    BareSymbol adapted = this.symbols[j].applyCopy(changes);
                    adapted.applyDiacriticLabel(dia.getLabel(i));
                    adapted.comments = adapted.comments + " " + dia.getDescription(i).substring(0, 4);
                    this.addSymbol(adapted);
                    continue;
                }
                System.out.print(".");
            }
            System.out.println("done.");
            System.out.println("     (I now have " + Integer.toString(this.symbols.length) + " symbols.");
        }
    }

    int addSymbol(BareSymbol symb) {
        int n = this.symbols.length;
        BareSymbol[] newSymb = new BareSymbol[n + 1];
        for (int i = 0; i < n; ++i) {
            newSymb[i] = this.symbols[i];
        }
        newSymb[n] = symb;
        this.symbols = newSymb;
        return n;
    }

    void addSymbol(Symbol symb) {
        this.addSymbol(new BareSymbol(symb));
    }

    public String toString() {
        int i;
        StringBuffer buff = new StringBuffer();
        buff.append("Symbol\tFile\tComments\t");
        for (i = 0; i < this.features.length; ++i) {
            buff.append("\t" + this.features[i]);
        }
        buff.append("\n");
        for (i = 0; i < this.symbols.length; ++i) {
            buff.append(this.symbols[i].toString() + "\n");
        }
        return buff.toString();
    }

    public void showAsFrame(MainScreen parentForm, ResourceProvider res) {
        this.showAsFrame(parentForm, res, null);
    }

    public void showAsFrame(MainScreen parentForm, ResourceProvider r, String message) {
        FrameFeatureList listFrame = new FrameFeatureList(this, parentForm, message, r);
        listFrame.setVisible(true);
    }

    public String[] getFeatures() {
        return this.features;
    }

    public BareSymbol getBareSymbol(int i) {
        return this.symbols[i];
    }

    public PartialSymbol getMaximalSymbol() {
        PartialSymbol symb = new PartialSymbol();
        int n = this.features.length * 2;
        symb.feature = new int[n];
        symb.value = new char[n];
        for (int i = 0; i < this.features.length; ++i) {
            symb.feature[2 * i] = i;
            symb.value[2 * i] = 43;
            symb.feature[2 * i + 1] = i;
            symb.value[2 * i + 1] = 45;
        }
        return symb;
    }

    public void updateTableProperties() {
    }

    public int getColumnCount() {
        return this.features.length + 3;
    }

    public int getRowCount() {
        return this.symbols.length;
    }

    public String getColumnName(int col) {
        String name = "";
        if (col > 2) {
            name = this.features[col - 3];
        }
        return name;
    }

    public Class getColumnClass(int col) {
        if (col > 2) {
            return Character.class;
        }
        return String.class;
    }

    public Object getValueAt(int row, int col) {
        Object value;
        BareSymbol symb = this.symbols[row];
        switch (col) {
            case -1: {
                return this.symbols[row];
            }
            case 0: {
                value = symb.getAntecedent();
                break;
            }
            case 1: {
                if (this.isTransformed()) {
                    value = "\u2192";
                    break;
                }
                value = "";
                break;
            }
            case 2: {
                value = symb.getLabel();
                break;
            }
            default: {
                value = Character.valueOf(symb.getDisplayableFeatureValue(col - 3));
            }
        }
        return value;
    }

    public void fireLabelUpdated(int i) {
        this.fireTableCellUpdated(i, 2);
    }

    public boolean isUnknown(int row) {
        return this.symbols[row].label.equals("?");
    }

    public boolean isTransformed() {
        if (this.symbols.length == 0) {
            return false;
        }
        return this.symbols[0].isTransformed();
    }

    public boolean isReferent(int i) {
        return false;
    }

    public boolean isReferential() {
        return false;
    }

    public boolean valueSameAsReferent(int row, int i) {
        return true;
    }

    public Color getColorFor(int i) {
        return null;
    }

    public DefaultTableCellRenderer getRenderer(boolean centered, int size, CompiledContradictions cc, ResourceProvider r) {
        return new FeatureTableRenderer(centered, size, this, cc, r);
    }

    public boolean isVoid() {
        return this.symbols.length == 0;
    }

    public class CompiledContradictions {
        Contradictions contradictions;
        PartialSymbol[] matches;

        public CompiledContradictions(BareFeatureList encaps, Contradictions contras) {
            this.contradictions = contras;
            if (!encaps.isVoid()) {
                this.matches = new PartialSymbol[contras.matches.length];
                for (int i = 0; i < contras.matches.length; ++i) {
                    BareFeatureList bareFeatureList2 = encaps;
                    bareFeatureList2.getClass();
                    this.matches[i] = bareFeatureList2.new PartialSymbol(contras.matches[i]);
                }
            }
        }

        public int[] findContradictions(BareSymbol symbol) {
            boolean[] violations = new boolean[this.matches.length];
            int nViolations = 0;
            for (int i = 0; i < this.matches.length; ++i) {
                MatchReport test = symbol.matchByFeatures(this.matches[i]);
                if (!test.isMatch() || !test.hasAllFeatures()) continue;
                violations[i] = true;
                ++nViolations;
            }
            int j = 0;
            int[] contradictions = new int[nViolations];
            for (int i = 0; i < this.matches.length; ++i) {
                if (!violations[i]) continue;
                contradictions[j] = i;
                ++j;
            }
            return contradictions;
        }
    }

    public class CompiledDependencies {
        Dependencies dependencies;
        PartialSymbol[] from;
        PartialSymbol[] to;

        public CompiledDependencies(BareFeatureList encaps, Dependencies deps) {
            this.dependencies = deps;
            if (!encaps.isVoid()) {
                this.from = new PartialSymbol[deps.from.length];
                this.to = new PartialSymbol[deps.from.length];
                for (int i = 0; i < deps.from.length; ++i) {
                    BareFeatureList bareFeatureList2 = encaps;
                    bareFeatureList2.getClass();
                    this.from[i] = bareFeatureList2.new PartialSymbol(deps.from[i]);
                    BareFeatureList bareFeatureList3 = encaps;
                    bareFeatureList3.getClass();
                    this.to[i] = bareFeatureList3.new PartialSymbol(deps.to[i]);
                }
            }
        }

        public BareSymbol applyTo(BareFeatureList encaps, BareSymbol input, BareSymbol antecedent) {
            MatchReport report;
            int i;
            for (i = 0; i < this.from.length; ++i) {
                report = input.matchByFeatures(this.from[i]);
                MatchReport original = antecedent.matchByFeatures(this.from[i]);
                if (!report.hasAllFeatures() || !report.isMatch() || original.isMatch()) continue;
                input = input.apply(encaps, this.to[i], report);
            }
            for (i = 0; i < this.from.length; ++i) {
                report = input.matchByFeatures(this.from[i]);
                if (!report.hasAllFeatures() || !report.isMatch()) continue;
                input = input.apply(encaps, this.to[i], report);
            }
            return input;
        }

        public String toString() {
            StringBuffer out = new StringBuffer();
            out.append("(Dependencies:\n");
            for (int i = 0; i < this.from.length; ++i) {
                out.append("\t" + this.from[i].toString() + " ==> " + this.to[i].toString() + "\n");
            }
            out.append(")\n");
            return out.toString();
        }
    }

    public class PartialSymbol {
        public int[] feature;
        public char[] value;

        public PartialSymbol() {
            this.feature = new int[0];
            this.value = new char[0];
        }

        public PartialSymbol(Symbol original) {
            this.feature = new int[original.features.length];
            this.value = new char[original.features.length];
            for (int i = 0; i < original.features.length; ++i) {
                int feat = -1;
                for (int j = 0; j < BareFeatureList.this.features.length; ++j) {
                    if (!original.features[i].equals(BareFeatureList.this.features[j])) continue;
                    feat = j;
                }
                if (feat == -1) {
                    System.err.println("Warning: cannot find feature '" + original.features[i] + "' of symbol " + original.toString() + " in our feature table.");
                    continue;
                }
                this.feature[i] = feat;
                this.value[i] = original.values[i];
            }
        }

        public PartialSymbol(BareSymbol original) {
            int n = 0;
            for (int i = 0; i < original.values.length; ++i) {
                if (original.values[i] == '0') continue;
                ++n;
            }
            this.feature = new int[n];
            this.value = new char[n];
            int feat = 0;
            for (int i = 0; i < original.values.length; ++i) {
                if (original.values[i] == '0') continue;
                this.feature[feat] = i;
                this.value[feat] = original.values[i];
                ++feat;
            }
        }

        public int getLength() {
            return this.feature.length;
        }

        public String toString() {
            int i;
            StringBuffer buff = new StringBuffer();
            for (i = 0; i < this.feature.length; ++i) {
                buff.append("(" + Integer.toString(this.feature[i]) + "," + this.value[i] + ") ");
            }
            buff.append("; or, human-readable, [");
            for (i = 0; i < this.feature.length; ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(this.value[i] + BareFeatureList.this.features[this.feature[i]]);
            }
            buff.append("]");
            return buff.toString();
        }

        public String toStringNamed() {
            StringBuffer buff = new StringBuffer();
            buff.append("[");
            for (int i = 0; i < this.feature.length; ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(this.value[i] + BareFeatureList.this.features[this.feature[i]]);
            }
            buff.append("]");
            return buff.toString();
        }

        public String toStringNamedRowed(int rowSize) {
            StringBuffer buff = new StringBuffer();
            buff.append("[");
            for (int i = 0; i < this.feature.length; ++i) {
                if (i > 0) {
                    buff.append(", ");
                    if (i % rowSize == 0) {
                        buff.append("\n");
                    }
                }
                buff.append(this.value[i] + BareFeatureList.this.features[this.feature[i]]);
            }
            buff.append("]");
            return buff.toString();
        }

        public PartialSymbol getCopy(BareFeatureList encaps) {
            PartialSymbol ret = encaps.new PartialSymbol();
            ret.feature = new int[this.feature.length];
            ret.value = new char[this.feature.length];
            for (int i = 0; i < ret.feature.length; ++i) {
                ret.feature[i] = this.feature[i];
                ret.value[i] = this.value[i];
            }
            return ret;
        }

        public void addFeatureValue(int f, char v) {
            int[] newF = new int[this.feature.length + 1];
            char[] newV = new char[this.feature.length + 1];
            for (int i = 0; i < this.feature.length; ++i) {
                newF[i] = this.feature[i];
                newV[i] = this.value[i];
            }
            newF[this.feature.length] = f;
            newV[this.feature.length] = v;
            this.feature = newF;
            this.value = newV;
        }

        public PartialSymbol eliminateFeature(int index) {
            PartialSymbol symb = new PartialSymbol();
            symb.feature = new int[this.value.length - 1];
            symb.value = new char[this.value.length - 1];
            int j = 0;
            for (int i = 0; i < this.value.length - 1; ++i) {
                j = i < index ? i : i + 1;
                symb.feature[i] = this.feature[j];
                symb.value[i] = this.value[j];
            }
            return symb;
        }

        public int getFeatureOccurrences(int f) {
            int n = 0;
            for (int i = 0; i < this.feature.length; ++i) {
                if (this.feature[i] != f) continue;
                ++n;
            }
            return n;
        }

        public void removeFeature(int f) {
            int n = this.getFeatureOccurrences(f);
            int[] newF = new int[this.feature.length - n];
            char[] newV = new char[this.feature.length - n];
            int j = 0;
            for (int i = 0; i < this.feature.length; ++i) {
                if (this.feature[i] == f) continue;
                newF[j] = this.feature[i];
                newV[j] = this.value[i];
                ++j;
            }
            this.feature = newF;
            this.value = newV;
        }

        public void removeFeatureValue(int f, char v) {
            boolean isDone = false;
            int[] newF = new int[this.feature.length - 1];
            char[] newV = new char[this.feature.length - 1];
            int j = 0;
            for (int i = 0; i < this.feature.length; ++i) {
                if (!isDone && this.feature[i] == f && this.value[i] == v) {
                    isDone = true;
                    continue;
                }
                newF[j] = this.feature[i];
                newV[j] = this.value[i];
                ++j;
            }
            this.feature = newF;
            this.value = newV;
        }
    }

    public class BareSymbol {
        char[] values;
        String label;
        String comments;
        String antecedent;
        public ComplexSymbol origin = null;

        BareSymbol(String[] rawdata) {
            this.label = rawdata[0];
            this.antecedent = "";
            this.comments = "";
            this.values = new char[BareFeatureList.this.features.length];
            for (int i = 0; i < BareFeatureList.this.features.length; ++i) {
                this.values[i] = rawdata[i + 2].charAt(0);
            }
        }

        BareSymbol(BaseSymbol symb) {
            this.label = symb.symbol;
            this.antecedent = "";
            this.comments = "";
            this.values = symb.values;
        }

        BareSymbol() {
            this.label = "";
            this.antecedent = "";
            this.values = new char[BareFeatureList.this.features.length];
            this.comments = "";
            for (int i = 0; i < BareFeatureList.this.features.length; ++i) {
                this.values[i] = 48;
            }
        }

        BareSymbol(Symbol symbol) {
            this.label = symbol.symbol;
            this.antecedent = symbol.antecedent;
            this.comments = "";
            this.values = new char[BareFeatureList.this.features.length];
            for (int i = 0; i < BareFeatureList.this.features.length; ++i) {
                this.values[i] = symbol.getValueForFeature(BareFeatureList.this.features[i]);
            }
        }

        public Symbol toSymbol() {
            Symbol symb = new Symbol();
            symb.symbol = this.getLabel();
            symb.features = BareFeatureList.this.features;
            symb.values = this.values;
            return symb;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isUnknown() {
            return this.label.equals("?");
        }

        public boolean hasFeature(String f) {
            return this.getFeature(f) > -1;
        }

        public int getFeature(String f) {
            for (int i = 0; i < BareFeatureList.this.features.length; ++i) {
                if (!BareFeatureList.this.features[i].equals(f)) continue;
                return i;
            }
            return -1;
        }

        public boolean featureMatchValue(int f, char val) {
            return this.values[f] == val;
        }

        public char getValue(int f) {
            return this.values[f];
        }

        public MatchReport matchByFeatures(PartialSymbol alternative) {
            MatchReport match = new MatchReport();
            for (int i = 0; i < alternative.feature.length; ++i) {
                int f = alternative.feature[i];
                char val = alternative.value[i];
                if (f == -1) {
                    match.declareDoesntHaveFeature();
                }
                if (!Symbol.isVariable(val)) {
                    if (this.featureMatchValue(f, val)) continue;
                    match.declareMisMatch();
                    return match;
                }
                if (f == -1 || this.featureMatchValue(f, '0')) {
                    match.declareMisMatch();
                    return match;
                }
                int varval = Symbol.getVariableIndex(val);
                if (varval > -1) {
                    if (match.variableSettings[varval] == '0') {
                        match.variableSettings[varval] = this.getValue(f);
                    } else if (!this.featureMatchValue(f, match.variableSettings[varval])) {
                        match.declareMisMatch();
                    }
                }
                if ((varval = Symbol.getNonVariableIndex(val)) <= -1) continue;
                if (match.variableSettings[varval] == '0') {
                    match.variableSettings[varval] = Symbol.opposite(this.getValue(f));
                    continue;
                }
                if (this.featureMatchValue(f, Symbol.opposite(match.variableSettings[varval]))) continue;
                match.declareMisMatch();
            }
            return match;
        }

        public BareSymbol apply(BareFeatureList encloser, PartialSymbol transform, MatchReport match) {
            BareSymbol symb = encloser.new BareSymbol();
            symb.label = "?";
            symb.values = new char[this.values.length];
            for (int i = 0; i < BareFeatureList.this.features.length; ++i) {
                symb.values[i] = this.values[i];
            }
            match.transformFeaturesUsed = new boolean[transform.feature.length];
            for (int i = 0; i < transform.feature.length; ++i) {
                char val = transform.value[i];
                if (Symbol.isVariable(val)) {
                    val = match.getVariableValue(val);
                }
                match.transformFeaturesUsed[i] = symb.values[transform.feature[i]] != val;
                symb.values[transform.feature[i]] = val;
            }
            return symb;
        }

        public boolean equals(BareSymbol alt) {
            if (alt.values.length != this.values.length) {
                System.err.println("Error in BareSymbol.equals(): value arrays should be of same length.");
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == alt.values[i]) continue;
                return false;
            }
            return true;
        }

        public boolean equals(BaseSymbol alt) {
            if (alt.values.length != this.values.length) {
                System.err.println("Error in BareSymbol.equals(): value arrays should be of same length.");
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == alt.values[i]) continue;
                return false;
            }
            return true;
        }

        public char getDisplayableFeatureValue(int f) {
            char val = this.values[f];
            if (val == '0') {
                return ' ';
            }
            if (val == '-') {
                return '\u2212';
            }
            return val;
        }

        public char getDisplayableFeatureValueWithNull(int f) {
            char val = this.values[f];
            if (val == '-') {
                return '\u2212';
            }
            return val;
        }

        public boolean matches(PartialSymbol symb) {
            boolean match = true;
            for (int i = 0; i < symb.feature.length; ++i) {
                if (this.values[symb.feature[i]] == symb.value[i]) continue;
                match = false;
            }
            return match;
        }

        private BareSymbol restrictFeatures(int[] fs) {
            BareSymbol symb = new BareSymbol();
            symb.label = this.label;
            symb.antecedent = this.antecedent;
            symb.comments = this.comments;
            symb.values = new char[fs.length];
            for (int i = 0; i < fs.length; ++i) {
                symb.values[i] = this.values[fs[i]];
            }
            return symb;
        }

        private PartialSymbol restrictToPartial(int[] fs) {
            PartialSymbol symb = new PartialSymbol();
            symb.feature = new int[fs.length];
            symb.value = new char[fs.length];
            for (int i = 0; i < fs.length; ++i) {
                symb.feature[i] = fs[i];
                symb.value[i] = this.values[fs[i]];
            }
            return symb;
        }

        public BareSymbol applyCopy(PartialSymbol changes) {
            int i;
            BareSymbol symb = new BareSymbol();
            symb.label = this.label;
            symb.antecedent = this.antecedent;
            symb.comments = this.comments;
            symb.values = new char[this.values.length];
            for (i = 0; i < BareFeatureList.this.features.length; ++i) {
                symb.values[i] = this.values[i];
            }
            for (i = 0; i < changes.feature.length; ++i) {
                symb.values[changes.feature[i]] = changes.value[i];
            }
            return symb;
        }

        public void applyDiacriticLabel(String diaLabel) {
            this.label = this.label + diaLabel;
        }

        public int getDistanceTo(BareSymbol alt) {
            int d = 0;
            for (int i = 0; i < alt.values.length; ++i) {
                if (alt.values[i] == this.values[i]) continue;
                ++d;
            }
            return d;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("\"" + this.label + "\"\t\"" + this.antecedent + "\"\t\"" + this.comments + "\"");
            for (int i = 0; i < BareFeatureList.this.features.length; ++i) {
                ret.append("\t\"" + this.values[i] + "\"");
            }
            return ret.toString();
        }

        public String toStringReadable() {
            StringBuffer ret = new StringBuffer();
            ret.append("[" + this.label + "] (" + this.antecedent + ") [");
            for (int i = 0; i < BareFeatureList.this.features.length; ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(this.values[i] + BareFeatureList.this.features[i]);
            }
            return ret.toString();
        }

        public boolean isTransformed() {
            return this.antecedent.length() > 0;
        }

        public String getAntecedent() {
            return this.antecedent;
        }
    }

    public class MinimalityReport {
        public boolean featureSelectionsMinimal = true;
        public boolean featureLeavingIdentity = false;
    }
}

